//---------------------------------------------------------------------------

#ifndef Main_FormH
#define Main_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <FileCtrl.hpp>
#include <Buttons.hpp>
#include "CGAUGES.h"
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"
#include "TntStdCtrls.hpp"
//---------------------------------------------------------------------------
class TMainForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntPanel *ImagePanel;
	TTntScrollBox *ScrollBox1;
	TTntImage *Image1;
	TTntPanel *Panel3;
	TTntPanel *Panel4;
	TTntLabel *Label1;
	TTntEdit *DirectoryEdit;
	TTntGroupBox *GroupBox1;
	TFileListBox *FileListBox;
	TTntSpeedButton *DataCompressSpeedButton;
	TTntSpeedButton *DataExtractSpeedButton;
	TTntSpeedButton *DataUpConversionSpeedButton;
	TTntSpeedButton *DataDownConversionSpeedButton;
	TTntPanel *Panel5;
	TDirectoryListBox *DirectoryListBox;
	TDriveComboBox *DriveComboBox1;
	TTntButton *StartButton;
	TTntButton *BreakButton;
	TTntPanel *Panel6;
	TTntGroupBox *GroupBox2;
	TTntCheckBox *CheckBox1;
	TCGauge *ProductImageProgressCGauge;
	TTntCheckBox *RemoveSourceCheckBox;
	TTntGroupBox *GroupBox3;
	TTntListBox *ContentsListBox;
	TTntPanel *DataConversionPanel;
	TTntCheckBox *ExtractProductImageCheckBox;
	TTntCheckBox *ExtractDefectImageCheckBox;
	TTntLabel *Label2;
	TTntLabel *SrcDirLabel;
	void __fastcall StartButtonClick(TObject *Sender);
	void __fastcall DirectoryListBoxChange(TObject *Sender);
	void __fastcall BreakButtonClick(TObject *Sender);
	void __fastcall FileListBoxChange(TObject *Sender);
	void __fastcall ContentsListBoxClick(TObject *Sender);
	void __fastcall DataCompressSpeedButtonClick(TObject *Sender);
	void __fastcall DataExtractSpeedButtonClick(TObject *Sender);
	void __fastcall DataUpConversionSpeedButtonClick(TObject *Sender);
	void __fastcall DataDownConversionSpeedButtonClick(TObject *Sender);
private:	// User declarations
	bool BreakProcess;
	AnsiString SelectedFACFileName;

	void __fastcall ApplyDirChange(void);
	void __fastcall CompressFolder(void);
	void __fastcall CompressData(AnsiString srcDir, bool bRemoveSrc, bool bCompressProductImage, bool bCompressDefectImage);
	void __fastcall ExtractBitmap(void);
	bool __fastcall ExtractImageFromContainer(Graphics::TBitmap *bitmap, AnsiString containerFileName, AnsiString bitmapName);

	void __fastcall ExtractData(AnsiString srcDir, bool bRemoveSrc, bool bExtractProductImage, bool bExtractDefectImage);
	void __fastcall ExtractDataRecursively(AnsiString srcDir, bool bRemoveSrc, bool bExtractProductImage, bool bExtractDefectImage);
	void __fastcall CompressDataRecursively(AnsiString srcDir, bool bRemoveSrc, bool bExtractProductImage, bool bExtractDefectImage);
	void __fastcall DataDownConversion(void);
	void __fastcall DataUpConversion(void);


public:		// User declarations
	__fastcall TMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
